//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Data
{
    struct st_Reg
    {
        double  h_value;
        uint    k_value;
    }Values[];
};
//+------------------------------------------------------------------+
bool Set(st_Data &dst, const uint &arg1[], const double &arg2[])
{
    if (arg1.Size() != arg2.Size())
        return false;
    
    ArrayResize(dst.Values, arg1.Size());
    for (uint c = 0; c < arg1.Size(); c++)
    {
        dst.Values[c].k_value = arg1[c];
        dst.Values[c].h_value = arg2[c];
    }

    return true;
}
//+------------------------------------------------------------------+
string Get(const st_Data &src, const uint index)
{
    for (uint c = 0; c < src.Values.Size(); c++)
        if (src.Values[c].k_value == index)
            return DoubleToString(src.Values[c].h_value, 2);

    return "-nan";
}
//+------------------------------------------------------------------+
#define PrintX(X) Print(#X, " => ", X)
//+------------------------------------------------------------------+
void OnStart(void)
{
    const double H[] = {2.05, 1.97, 1.87, 1.75, 1.99, 2.01, 1.83};
    const uint   K[] = {2, 1, 4, 0, 5, 3, 6};

    st_Data info;

    Set(info, K, H);
    PrintX(Get(info, 3));
}
//+------------------------------------------------------------------+